#ifndef _CommonDialog_CPP
#define _CommonDialog_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <ShlObj.H>
#include <Stdio.H>
#include <ShlOBJ.H>
#include <Stdlib.H>

#include "../Resources/Resource.H"

#include "../Modules/NASCCL/NASCCL.H"

#include "NSWFL.H"
#include "Package.H"
#include "Entry.H"
#include "Common.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char gsExtractLocation[255 + 1];

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char *FormatiString(char *outStr, char *inStr)
{
    int RPos = strlen(inStr) - 1;
    int WPos = 0;
    int DPos = 0;

    if(RPos < 3)
    {
        strcpy(outStr, inStr);
        return outStr;
    }

    while(RPos != -1)
    {
        if(DPos == 3)
        {
            outStr[WPos] = ',';
            WPos++;
            DPos = 0;
        }

        outStr[WPos] = inStr[RPos];

        RPos--;
        WPos++;
        DPos++;
    }

    ReverseString(outStr, WPos);

    outStr[WPos] = '\0';

    return outStr;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char *FormatInteger(char *outStr, long inLong)
{
    char Long[64];
    sprintf(Long, "%d", inLong);
    return FormatiString(outStr, Long);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void SetStatusFileName(HWND xHandle, char *StatusText)
{
    char LocalBuffer[60 + 1];

    int Length = strlen(StatusText);
    int RPos = 0;
    int WPos = 0;
    int MinPos = (Length - 60);

    if(Length <= 60)
    {
        Set_Text(xHandle, StatusText);
        return;
    }

    RPos = Length;

    while(RPos != MinPos)
    {
        if(StatusText[RPos] == '\\')
            break;

        RPos--;
    }

    while(RPos < Length)
    {
        LocalBuffer[WPos] = StatusText[RPos];
        RPos++;
        WPos++;
    }

    LocalBuffer[WPos] = '\0';

    Set_Text(xHandle, LocalBuffer);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CreateFolderStructure(char *FullFileName)
{
    char Directory[256];

    int NameLength = strlen(FullFileName);
    int Position = 0;

    while(Position < NameLength)
    {
        if(FullFileName[Position] == '\\' || FullFileName[Position] == '/')
        {
            Directory[Position] = '\0';
            CreateDirectory(Directory, NULL);
        }

        Directory[Position] = FullFileName[Position];

        Position++;
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

long Reflect_Checksum(long lReflect, char cChar)
{
	long Value = 0;

	// Swap Bit 0 For Bit 7 Bit 1 For Bit 6, Etc....
	for(int Loop = 1; Loop < (cChar + 1); Loop++)
	{
		if(lReflect & 1)
        {
            Value |= 1 << (cChar - Loop);
        }

		lReflect >>= 1;
	}

	return Value;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

long MakeChecksum(char *RawKey)
{
    char KeyHash[CHECKSUMLEN + 1];
    int RPos = 0;
    long Checksum = 0;

    HashKey(RawKey, KeyHash, strlen(RawKey), CHECKSUMLEN);

	while(RPos < CHECKSUMLEN)
    {
        Checksum = (Checksum + KeyHash[RPos]) + Reflect_Checksum(Checksum, KeyHash[RPos]);
        RPos++;
    }

    return Checksum;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GetLastDirectoryInPath(char *inFullPath, char *outLastDir)
{
    int RPos = (strlen(inFullPath) - 1);
    int WPos = 0;

    if(RPos <= 0)
    {
        outLastDir[0] = '\0';
        return false;
    }

    if(inFullPath[RPos] == '\\' || inFullPath[RPos] == '//')
    {
        RPos--;
    }

    if(inFullPath[RPos] != ':' && inFullPath[RPos-1] != ':')
    {
        while(RPos != 0 && inFullPath[RPos] != '\\' && inFullPath[RPos] != '//')
        {
            outLastDir[WPos] = inFullPath[RPos];
            RPos--;
            WPos++;
        }

        outLastDir[WPos++] = '\\';
        outLastDir[WPos] = '\0';
        ReverseString(outLastDir, WPos);
    }
    else{
        outLastDir[0] = '\0';
        return false;
    }

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void AllocIconList(LPDBGICONLIST lpMyIconList, int ExtLen, int DescrLen)
{
    lpMyIconList->Ext = (char *) calloc(sizeof(char), ExtLen + 1);
    lpMyIconList->Descr = (char *) calloc(sizeof(char), DescrLen + 1);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FreeIconList(LPDBGICONLIST lpMyIconList)
{
    free(lpMyIconList->Ext);
    free(lpMyIconList->Descr);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GetIconForExt(char *inExt, char *outIconFile, int *outIconIndex, char *outDescr)
{
    char lsKey[256];
    char lsDefaultIcon[256];
    char lsTempKey[256];
    char Temp[256];
    DWORD dwBufferLen = 256;

    memset(lsKey, 0, sizeof(lsKey));
    memset(lsTempKey, 0, sizeof(lsTempKey));
    memset(lsDefaultIcon, 0, sizeof(lsDefaultIcon));

    dwBufferLen = 256;
    if(!Get_StringRegistryValue(HKEY_CLASSES_ROOT, inExt, NULL, lsKey, dwBufferLen))
        return false;

    dwBufferLen = 256;
    if(!Get_StringRegistryValue(HKEY_CLASSES_ROOT, lsKey, NULL, outDescr, dwBufferLen))
        return false;

    dwBufferLen = 256;
    sprintf(lsTempKey, "%s\\DefaultIcon", lsKey);
    if(!Get_StringRegistryValue(HKEY_CLASSES_ROOT, lsTempKey, NULL, lsDefaultIcon, dwBufferLen))
        return false;

    int RPos = strlen(lsDefaultIcon) - 1;
    int WPos = 0;

    while(RPos > 1)
    {
        if(lsDefaultIcon[RPos] != ' ' && lsDefaultIcon[RPos] != '\t')
        {
            if(lsDefaultIcon[RPos] == ',')
            {
                lsDefaultIcon[RPos] = '\0';
                break;
            }

            if(!(lsDefaultIcon[RPos] >= '0' && lsDefaultIcon[RPos] <= '9') && lsDefaultIcon[RPos] != '-')
            {
                break;
            }

            Temp[WPos] = lsDefaultIcon[RPos];
            WPos++;
        }

        RPos--;
    }

    if(WPos > 0)
    {
        ReverseString(Temp, WPos);
        *outIconIndex = atoi(Temp);
    }

    strcpy(outIconFile, lsDefaultIcon);

    return true;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

